<?php
// Enable error reporting for debugging (recommended during setup)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// Ensure the antibot_gate.php and botMother.php are in the same directory
// and config.php is in the same directory.
require_once(__DIR__ . "/antibot_gate.php"); // Path to the new anti-bot gate
require_once(__DIR__ . "/botMother.php"); // Path to your existing botMother class

// Initialize and run the anti-bot gate
$antiBot = new AntiBotGate();

// The run() method will either:
// 1. Mark session as human and return true (if already verified or test mode).
// 2. Detect a bot silently and display CAPTCHA (and exit).
// 3. Handle CAPTCHA submission (verify, then proceed or redisplay CAPTCHA).
// 4. For the first visit (or non-bot initial visit), display CAPTCHA for verification.
if ($antiBot->run()) {
    // If antiBot->run() returns true, it means the user is verified as human,
    // and we can now safely include the React application.
    include("app.html"); 
} else {
    // This else block should theoretically not be reached if showCaptcha() exits
    // or run() returns true. It's a fallback for unexpected scenarios.
    // In practice, showCaptcha() will exit PHP execution.
}
?>
